/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2008. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
package junit.awtui;

import java.awt.*;
/**
 * A progress bar to show progress on
 */
public class ProgressBar extends Canvas {
	private static final long serialVersionUID = -9157418243100930959L;
	
	private boolean fError= false;
	private int fTotal= 0;
	private int fProgress= 0;
	private int fProgressX= 0;

	/**
	 * Make a new progress bar
	 */
	public ProgressBar() {
		super();
		setSize(20, 30);
	}
	
	private Color getStatusColor() {
		return fError ? Color.red : Color.green;
	}
	
	/**
     * Custom paint the logo canvas. 
     * @param      g   the specified Graphics context
     */
	public void paint(Graphics g) {
		paintBackground(g);
		paintStatus(g);
	}
	
	/**
	 * TODO document me
	 */
	public void paintBackground(Graphics g) {
		g.setColor(SystemColor.control);
		Rectangle r= getBounds();
		g.fillRect(0, 0, r.width, r.height);
		g.setColor(Color.darkGray);
		g.drawLine(0, 0, r.width-1, 0);
		g.drawLine(0, 0, 0, r.height-1);
		g.setColor(Color.white);
		g.drawLine(r.width-1, 0, r.width-1, r.height-1);
		g.drawLine(0, r.height-1, r.width-1, r.height-1);
	}
	
	/**
	 * TODO document me
	 */
	public void paintStatus(Graphics g) {
		g.setColor(getStatusColor());
		Rectangle r= new Rectangle(0, 0, fProgressX, getBounds().height);
		g.fillRect(1, 1, r.width-1, r.height-2);
	}
	
	private void paintStep(int startX, int endX) {
		repaint(startX, 1, endX-startX, getBounds().height-2);
	}
	
	/**
	 * TODO document me
	 */
	public void reset() {
		fProgressX= 1;
		fProgress= 0;
		fError= false;
		paint(getGraphics());
	}
	
	/**
	 * TODO document me
	 */
	public int scale(int value) {
		if (fTotal > 0)
			return Math.max(1, value*(getBounds().width-1)/fTotal);
		return value; 
	}
	
    /**
     * Moves and resizes this component. The new location of the top-left
     * corner is specified by <code>x</code> and <code>y</code>, and the
     * new size is specified by <code>width</code> and <code>height</code>.
     * @param x the new <i>x</i>-coordinate of this component
     * @param y the new <i>y</i>-coordinate of this component
     * @param width the new <code>width</code> of this component
     * @param height the new <code>height</code> of this 
     *          component
     */
	public void setBounds(int x, int y, int w, int h) {
		super.setBounds(x, y, w, h);
		fProgressX= scale(fProgress);
	}
	
	/**
	 * TODO document me
	 */
	public void start(int total) {
		fTotal= total;
		reset();
	}
	
	/**
	 * TODO document me
	 */
	public void step(boolean successful) {
		fProgress++;
		int x= fProgressX;

		fProgressX= scale(fProgress);

		if (!fError && !successful) {
			fError= true;
			x= 1;
		}
		paintStep(x, fProgressX);
	}
}